// Pega o formulário do HTML pelo ID
const formDenuncia = document.getElementById('form-denuncia');

// Adiciona um "escutador" para o evento de "submit" (envio) do formulário
formDenuncia.addEventListener('submit', (event) => {
    // Impede que a página recarregue ao enviar o formulário
    event.preventDefault();

    // Pega os valores dos campos do formulário
    const tipoViolencia = document.getElementById('tipo-violencia').value;
    const descricao = document.getElementById('descricao').value;
    const anonimo = document.getElementById('anonimo').checked; // .checked retorna true ou false

    // Monta um objeto com os dados da denúncia
    const denuncia = {
        tipo: tipoViolencia,
        descricao: descricao,
        anonima: anonimo,
        data: new Date() // Adiciona a data e hora do envio
    };

    // Envia o objeto "denuncia" para o banco de dados Firestore
    // A linha abaixo cria (ou usa) uma "coleção" chamada "denuncias" e adiciona um novo documento
    db.collection("denuncias").add(denuncia)
        .then((docRef) => {
      const tempoDeChegada = Math.floor(Math.random() * (15 - 5 + 1)) + 5;

    // 2. Pegar os elementos do HTML que vamos manipular.
    const formElement = document.getElementById('form-denuncia');
    const containerMensagem = document.getElementById('mensagem-confirmacao');

    // 3. Montar a mensagem de confirmação.
    containerMensagem.innerHTML = `Ajuda a caminho. Uma viatura da polícia foi notificada e a chegada está estimada em aproximadamente <strong>${tempoDeChegada} minutos</strong>. Se possível, procure um local seguro.`;

    // 4. Esconder o formulário.
    formElement.style.display = 'none';

    // 5. Mostrar a mensagem de confirmação no lugar.
    containerMensagem.style.display = 'block';

 
})
});